/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-21
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEWINDOWLAYER_H
#define TIMEWINDOWLAYER_H

#include <SciFigs.h>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class SignalLayer;

class GEOPSYGUI_EXPORT TimeWindowLayer : public GraphContentsLayer
{
  Q_OBJECT
  Q_PROPERTY(double size READ size WRITE setSize SCRIPTABLE true)
  Q_PROPERTY(bool showColors READ showColors WRITE setShowColors SCRIPTABLE true)
public:
  TimeWindowLayer(AxisWindow * parent=nullptr);
  TimeWindowLayer(SignalLayer * sig);
  virtual ~TimeWindowLayer();

  void setWindowOwnership(bool o) {_windowOwner=o;}

  virtual const QString& xml_tagName() const {return xmlTimeWindowLayerTag;}
  static const QString xmlTimeWindowLayerTag;

  void addTimeWindows(const SubSignalPool& subPool, TimeWindowList * l);
  void addTimeWindows(Signal * sig, TimeWindowList * l);
  void clearTimeWindows();

  virtual Rect boundingRect() const;

  double size() const {return _size;}
  void setSize(double s);

  bool showColors() const {return _showColors;}
  void setShowColors(bool b);

  enum TrackingModes{Add, Remove};
  void toggleTrackingAction(bool checked, int id=-1);
  bool trackRectangle(int id, double rx1, double ry1, double rx2, double ry2, Qt::KeyboardModifiers);
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual void xml_layerPolish(XML_POLISH_ARGS);
signals:
  void addWindows(const Signal * sig, const TimeRange& r);
  void removeWindows(const Signal * sig, const TimeRange& r);
private:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;

  void addTimeWindowsInternal(Signal * sig, TimeWindowList * l);
  inline void paintTimeWindows(const GraphContentsOptions& gc, QPainter& p,
                               const TimeWindowList& windows, const Signal * sig, int iSig) const;

  SignalLayer * _sig;
  QMap<const Signal *, TimeWindowList *> _windows;

  double _size;
  bool _showColors;
  bool _windowOwner;

  struct XMLTimeWindowList
  {
    QMap<int, TimeWindowList *> _windows;
    QString _signalLayerName;
  };
  XMLTimeWindowList * _xmlWindows;
};

} // namespace GeopsyGui

#endif // TIMEWINDOWLAYER_H
