/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FILTERPARAMETERWIDGET_H
#define FILTERPARAMETERWIDGET_H

#include <GeopsyCore.h>
#include "ui_FilterParameterWidget.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT FilterParameterWidget : public QWidget, private Ui::FilterParameterWidget
  {
    Q_OBJECT
  public:
    FilterParameterWidget(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    void getParameters(FilterParameters & param) const;
    void setParameters(const FilterParameters & param);
  public slots:
    void updateAllFields();
    void on_filterType_activated(int);
    void on_filterType_currentIndexChanged(int);
    void on_butterworthButton_toggled(bool);
    void on_frequencyWindowButton_toggled(bool);
  private:
    void setDefaultWindow();
  signals:
    void parametersChanged();
  };

} // namespace GeopsyGui

#endif // FILTERPARAMETERWIDGET_H
