/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-10-06
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CHRONOGRAMPROPERTIES_H
#define CHRONOGRAMPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_ChronogramProperties.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class ChronogramLayer;

  class GEOPSYGUI_EXPORT ChronogramProperties : public PropertyWidget, private Ui::ChronogramProperties
  {
    Q_OBJECT
  public:
    ChronogramProperties(QWidget* parent=0);

    enum Properties {MinimumGap};
    void setLayer(ChronogramLayer * layer);
  private slots:
    void on_exportButton_clicked();
  private:
    ChronogramLayer * _layer;
  };

} // namespace GeopsyGui

#endif // CHRONOGRAMPROPERTIES_H
