/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-11-30
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TaperDelegate.h"
#include "DoubleSignal.h"

namespace GeopsyCore {

  /*!
    \class TaperDelegate TaperDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  TaperDelegate::TaperDelegate(const WindowFunctionParameters * p)
  {
    TRACE;
    _parameters=p;
    _function=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  TaperDelegate::~TaperDelegate()
  {
    TRACE;
    delete _function;
  }

  void TaperDelegate::createFunction(int signalFirstSample, int signalLastSample,
                                     int windowFirstSample, int windowLastSample)
  {
    TRACE;
    delete _function;
    if(windowFirstSample<windowLastSample) {
#ifdef COMPATIBILITY_2_5_0
      _function=new WindowFunction(windowLastSample-windowFirstSample+2, *_parameters);
#else
      _function=new WindowFunction(windowLastSample-windowFirstSample+1, *_parameters);
#endif
      _function->setStartIndex(windowFirstSample);
      _function->setSignalRange(signalFirstSample, signalLastSample);
    } else {
      _function=nullptr;
    }
  }

  void TaperDelegate::createFunction(double start, double end,
                                     double samplingFrequency, int nSamples)
  {
    TRACE;
    createFunction(0, nSamples-1,
                   qRound(start*samplingFrequency),
                   qRound(end*samplingFrequency)-1);
  }

  /*!
    Generate a a flat signal at 1 and apply current window
  */
  void TaperDelegate::test(int nSamples, int startIndex, int endIndex)
  {
    TRACE;
    DoubleSignal * sig=new DoubleSignal(nSamples);
    sig->initValues(1.0, 0, nSamples);
    LOCK_SAMPLES(double, sigSamples, sig)
      TaperDelegate::RealSample samples(sigSamples);
      createFunction(0, nSamples-1, startIndex, endIndex);
      apply(samples);
    UNLOCK_SAMPLES(sig)
    sig->debugPrint();
    delete sig;
  }

  /*!
    \fn TaperDelegate::apply(sampleType samples, int signalFirstSample, int signalLastSample,
                            int windowFirstSample, int windowLastSample) const

    Outside \a signalFirstSample and \a signalLastSample the signal is not touched.
    Outside \a windowFirstSample and \a windowLastSample the affected signal is set to null or untouched.
    \a windowFirstSample and \a windowLastSample can be partially outside \a signalFirstSample and \a signalLastSample.
    The shape of the window is controled only by \a windowFirstSample and \a windowLastSample but
    if might be truncated by \a signalFirstSample and \a signalLastSample.
    The signal is modified between \a windowFirstSample and \a windowLastSample according
    to window function.

    \a windowFirstSample and \a windowLastSample can be outside the range \a signalFirstSample and \a signalLastSample.
  */

} // namespace GeopsyCore
