/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-03-20
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALGROUP_H
#define SIGNALGROUP_H

#include <QGpCoreTools.h>

#include "AbstractSignalGroup.h"
#include "SubSignalPool.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SignalGroup: public AbstractSignalGroup
  {
    TRANSLATIONS("SignalGroup")
  public:
    SignalGroup(AbstractSignalGroup * parent=nullptr);
    ~SignalGroup();

    const QString& xml_tagName() const {return xmlSignalGroupTag;}
    static const QString xmlSignalGroupTag;
    bool xml_inherits(const QString& tagName) const;

    void setName(const QString &n);
    int signalCount() const {return _signals.count();}
    bool hasOwnSignal() const {return true;}
    bool directlyContains(const Signal * sig) const;
    SubSignalPool subPool() const {return _signals;}

    virtual bool convertIds(const QHash<int, Signal *>& ids);
    bool hasIds() const {return _ids;}

    void removeSignal(Signal * sig);
    void removeAllSignals();
    virtual void setSignals(const SubSignalPool& subPool);
    virtual void addSignals(const SubSignalPool& subPool);

    void openV12(int dbVersion, const QDir& dbPath);
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
    XMLMember xml_member(XML_MEMBER_ARGS);
  private:
    SubSignalPool _signals;
    VectorList<int> * _ids;
  };

} // namespace GeopsyCore

#endif // SIGNALGROUP_H
