/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-03-29
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "RotateParameters.h"

namespace GeopsyCore {

  /*!
    \class RotateParameters RotateParameters.h
    \brief Storage for rotation parameters

    Up to 3 rotations can be chained in this order:
    \li around Z
    \li arount N
    \li around E

    Angles are all in degree counted in a counterclockwise direction about
    the axis (right hand rule).
  */

  /*!
    Default constructor: no rotation.
  */
  RotateParameters::RotateParameters()
    : AbstractParameters()
  {
    TRACE;
    _axes=None;
    _angleAroundVertical=0.0;
    _angleAroundNorth=0.0;
    _angleAroundEast=0.0;
  }

  /*!
    Copy constructor
  */
  RotateParameters::RotateParameters(const RotateParameters& o)
    : AbstractParameters(o)
  {
    TRACE;
    _axes=o._axes;
    _angleAroundVertical=o._angleAroundVertical;
    _angleAroundNorth=o._angleAroundNorth;
    _angleAroundEast=o._angleAroundEast;
  }

  /*!
    \fn axes()
    Returns the axis selection.
  */

  /*!
    \fn setAxes(Axes a)
    Set the axis selection.
  */

  /*!
    \fn angleAroundVertical()
    Returns the rotation angle around vertical axis (Z axis, degrees).
  */

  /*!
    \fn setAngleAroundVertical(double a)
    Set the rotation angle around vertical axis (Z axis, degrees).
  */

  /*!
    \fn angleAroundNorth()
    Returns the rotation angle around north axis (Y axis, degrees).
  */

  /*!
    \fn setAngleAroundN(double a)
    Set the rotation angle around north axis (Y axis, degrees).
  */

  /*!
    \fn angleAroundEast()
    Returns the rotation angle around east axis (X axis, degrees).
  */

  /*!
    \fn setAngleAroundEast(double a)
    Set the rotation angle around east axis (X axis, degrees).
  */

  /*!
    Returns the rotation matrix.
  */
  Matrix3x3 RotateParameters::matrix() const
  {
    TRACE;
    Matrix3x3 rot;
    rot.identity();
    Matrix3x3 elrot;
    Angle a;
    if(_axes & Vertical) {
      a.setDegrees(_angleAroundVertical);
      elrot.rotation(ZAxis, a);
      rot*=elrot;
    }
    if(_axes & North) {
      a.setDegrees(_angleAroundNorth);
      elrot.rotation(YAxis, a);
      rot*=elrot;
    }
    if(_axes & East) {
      a.setDegrees(_angleAroundEast);
      elrot.rotation(XAxis, a);
      rot*=elrot;
    }
    return rot;
  }

} // namespace GeopsyCore
