/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-09-20
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MORLETPARAMETERS_H
#define MORLETPARAMETERS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT MorletParameters: public AbstractParameters
  {
  public:
    MorletParameters();

    AbstractParameters * clone() const {return new MorletParameters(*this);}

    void setFi(double v) {_fi=v;}
    void setM(double v) {_m=v;}

    double fi() const {return _fi;}
    double m() const {return _m;}

    double deltaT() const;
    double deltaF() const;

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    double _fi;
    double _m;
  };

} // namespace GeopsyCore

#endif // MORLETPARAMETERS_H
