/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-12-22
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef INSTRUMENTALRESPONSE_H
#define INSTRUMENTALRESPONSE_H

#include <QGpCoreMath.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT InstrumentalResponse: public XMLClass
  {
  public:
    InstrumentalResponse();
    ~InstrumentalResponse();

    virtual const QString& xml_tagName() const {return xmlInstrumentalResponseTag;}
    static const QString xmlInstrumentalResponseTag;

    const QString& name() const {return _name;}
    void setName(const QString& n) {_name=n;}

    const VectorList<Complex>& poles() const {return _poles;}
    VectorList<Complex>& poles() {return _poles;}
    void addPole(const Complex& p) {_poles.append(p);}
    void clearPoles() {_poles.clear();}

    const VectorList<Complex>& zeros() const {return _zeros;}
    VectorList<Complex>& zeros() {return _zeros;}
    void addZero(const Complex& z) {_zeros.append(z);}
    void clearZeros() {_zeros.clear();}

    double noiseLevel() const {return _noiseLevel;}
    void setNoiseLevel(double n) {_noiseLevel=n;}

    double transductionFactor() const {return _transductionFactor;}
    void setTransductionFactor(double f) {_transductionFactor=f;}

    double normalizationFactor() const {return _normalizationFactor;}
    void setNormalizationFactor(double f) {_normalizationFactor=f;}

    double frequencyFactor() const {return _frequencyFactor;}
    void setFrequencyFactor(double f) {_frequencyFactor=f;}

    Complex deconvolution(double frequency, const Complex& sample=Complex(1.0)) const;
    Complex value(double frequency) const;

    QString arguments() const;

    virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
  private:
    QString _name;
    VectorList<Complex> _poles;
    VectorList<Complex> _zeros;
    double _noiseLevel;
    double _transductionFactor;
    double _normalizationFactor;
    double _frequencyFactor;
  };

} // namespace GeopsyCore

#endif // INSTRUMENTALRESPONSE_H


