/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-03
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DUPLICATERAYS_H
#define DUPLICATERAYS_H

#include "MetaData.h"
#include "SubSignalPool.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT DuplicateRays : public MetaData
{
  METADATA_CLASS(DuplicateRays)
public:
  DuplicateRays() {_rays=0;}
  ~DuplicateRays() {delete _rays;}

  virtual bool operator==(const MetaData& o) const;
  virtual void operator=(const MetaData&) {}

  void addRay(Signal * sig);
  const SubSignalPool& rays() const {return *_rays;}

  virtual bool isStored() const {return false;}
  virtual bool isReadOnly(int) const {return true;}

  virtual QStringList subNames() const;
  virtual QStringList indexList(int subId) const;
  virtual bool isArray(int subId) const;
  virtual int count(int subId) const;
  virtual bool hasIndex(int subId) const;
  virtual bool hasIndex(int subId, const QString& index) const;
  virtual QString name(int subId, const QString& index) const;
  virtual QString baseName(int subId) const;
  virtual QString title(int subId, const QString& index) const;
  virtual QVariant data(int subId, const QString& index) const;
  virtual int compare(int subId, const QString& index, const MetaData& o) const;
private:
  DateTime average(const QString& name) const;
  double standardDeviation(const QString& name) const;

  SubSignalPool * _rays;
  static QStringList _names;
};

} // namespace GeopsyCore

#endif // DUPLICATERAYS_H
