/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-20
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DEFAULTSIGNALGROUP_H
#define DEFAULTSIGNALGROUP_H

#include "GeopsyCoreDLLExport.h"
#include "AbstractSignalGroup.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT DefaultSignalGroup: public AbstractSignalGroup
  {
    TRANSLATIONS("DefaultSignalGroup")
  public:
    DefaultSignalGroup(SignalDatabase * database, AbstractSignalGroup * parent=nullptr);

    virtual const QString& xml_tagName() const {return xmlDefaultSignalGroupTag;}
    static const QString xmlDefaultSignalGroupTag;
    virtual bool xml_inherits(const QString& tagName) const;

    virtual bool readOnly() const {return true;}

    virtual bool hasOwnSignal() const {return true;}
    virtual bool stored() const {return false;}
    virtual bool contains(int) const {return false;}
    virtual bool convertIds(const QHash<int, Signal *>&) {return true;}
    virtual void removeSignal(Signal *) {}
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);

    SignalDatabase * database() const {return _database;}
  private:
    SignalDatabase * _database;
  };

  class AllSignalsGroup: public DefaultSignalGroup
  {
  public:
    AllSignalsGroup(SignalDatabase * database, AbstractSignalGroup * parent=nullptr);

    virtual SubSignalPool subPool() const;
  };

  class TemporarySignalsGroup: public DefaultSignalGroup
  {
  public:
    TemporarySignalsGroup(SignalDatabase * database, AbstractSignalGroup * parent=nullptr);

    virtual SubSignalPool subPool() const;
  };

  class AllFilesGroup: public DefaultSignalGroup
  {
  public:
    AllFilesGroup(SignalDatabase * database, AbstractSignalGroup * parent=nullptr);

    virtual SubSignalPool subPool() const;
  };

  class TemporaryFilesGroup: public DefaultSignalGroup
  {
  public:
    TemporaryFilesGroup(SignalDatabase * database, AbstractSignalGroup * parent=nullptr);

    virtual SubSignalPool subPool() const;
  };

  class PermanentFilesGroup: public DefaultSignalGroup
  {
  public:
    PermanentFilesGroup(SignalDatabase * database, AbstractSignalGroup * parent=nullptr);

    virtual SubSignalPool subPool() const;
  };


} // namespace GeopsyCore

#endif // DEFAULTSIGNALGROUP_H
