#include "qtbgeopsy.h"
#include "qtbsignaldb.h"
#include "qtbsignalgroup.h"
#include "qtbsubsignalpool.h"

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  // Initialization of geopsy library
  CoreApplication a(argc,argv,help);
  Geopsy gp;

  if (argc!=3) {
    App::stream() << tr("Usage: tomoinfo path/to/database.gpy groupPath") << endl;
    return 2;
  }
  if ( !gp.currentDB()->open( argv[1] ) ) {
    App::stream() << tr("tomoinfo: error opening database %1").arg( argv[1] ) << endl;
    return 2;
  }
  SignalGroup * g = gp.currentDB()->findGroup(argv[2]);
  if ( !g ) {
    App::stream() << tr("tomoinfo: group '%1' does not exist").arg( argv[2] ) << endl;
    return 2;
  }
  SubSignalPool sigs = g->subPool( gp.currentDB() );

  for(SubSignalPool::iterator it = sigs.begin(); it!=sigs.end(); it++) {
    Signal * sig = *it;
    App::stream() << sig->name() << " " << sig->timePick(0) << " seconds\n"
           << "  Receiver position: " << sig->receiver().toString() << "\n"
           << "  Source Position: " << sig->source().toString() << endl;
  }
  return 0;
}

ApplicationHelp * help()
{
  ApplicationHelp * h = new ApplicationHelp;
  h->setOptionSummary( "<FILE.gpy> <GROUP>" );
  h->setComments( "Example of libgeopsycore usage. It prints arrival time of first pick (0), "
                  "receiver and source coordinates for all signals of GROUP, which belongs "
                  "to database FILE.gpy." );
  return h;
}
