/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  DinverDCGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-21
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONVIEWER_H
#define REFRACTIONVIEWER_H

#include "DinverDCGuiDLLExport.h"
#include "DCModelViewer.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT RefractionViewer : public DCModelViewer
{
public:
  RefractionViewer(QWidget * parent=nullptr);
protected:
  virtual void setTitles(int i);
  virtual void setSampleCount(DCModelInfo * info, DCReportBlock& dcBlock);
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info);
  virtual void setLimits(int i, const Rect& r);
  virtual AbstractLine * targetReferenceLine() const;

  VectorList<double> _sources;
};

class DINVERDCGUI_EXPORT RefractionVpViewer : public RefractionViewer
{
public:
  RefractionVpViewer(QWidget * parent=nullptr);
  ~RefractionVpViewer();
protected:
  virtual bool hasCurves(DCReportBlock& dcBlock, int version);
  virtual void setTarget(const TargetList * tl);
};

class DINVERDCGUI_EXPORT RefractionVsViewer : public RefractionViewer
{
public:
  RefractionVsViewer(QWidget * parent=nullptr);
  ~RefractionVsViewer();
protected:
  virtual bool hasCurves(DCReportBlock& dcBlock, int version);
  virtual void setTarget(const TargetList * tl);
};

} // namespace DinverDCGui

#endif // REFRACTIONVIEWER_H
