/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPTICITYPEAKTARGET_H
#define ELLIPTICITYPEAKTARGET_H

#include "Target.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

  class DINVERDCCORE_EXPORT EllipticityPeakTarget : public Target
  {
  public:
    EllipticityPeakTarget();
    EllipticityPeakTarget(const EllipticityPeakTarget& o);

    virtual const QString& xml_tagName() const {return xmlEllipticityPeakTargetTag;}
    static const QString xmlEllipticityPeakTargetTag;

    const RealStatisticalValue& value() const {return _value;}
    RealStatisticalValue& value() {return _value;}
    void setValue(const RealStatisticalValue& v) {_value=v;}

    void setMinimumAmplitude(double a) {_minimumAmplitude=a;}
    double minimumAmplitude() const {return _minimumAmplitude;}
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    RealStatisticalValue _value;
    double _minimumAmplitude;
  };

} // namespace DinverDCCore

#endif // ELLIPTICITYPEAKTARGET_H
