/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AUTOCORRTARGET_H
#define AUTOCORRTARGET_H

#include <QGpCoreWave.h>
#include "Target.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT AutocorrTarget : public Target
{
public:
  AutocorrTarget();
  AutocorrTarget(const AutocorrTarget& o);

  virtual const QString& xml_tagName() const {return xmlAutocorrTargetTag;}
  static const QString xmlAutocorrTargetTag;

  const AutocorrCurves& curves() const {return _curves;}
  AutocorrCurves& curves() {return _curves;}
  void setCurves(const AutocorrCurves& c);
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polish(XML_POLISH_ARGS);
private:
  AutocorrCurves _curves;
};

} // namespace DinverDCCore

#endif // AUTOCORRTARGET_H
