/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-17
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SCALEDMODELS_H
#define SCALEDMODELS_H

#include "DinverCoreDLLExport.h"
#include "Index.h"

namespace DinverCore {

  class ActiveModels;
  class ModelSet;
  class BestModels;

  class DINVERCORE_EXPORT ScaledModels
  {
  public:
    ScaledModels(ActiveModels * m, double * scales);
    ~ScaledModels();

    int modelCount() const {return _modelCount;}
    int parameterCount() const {return _parameterCount;}

    double scale(int parameterIndex) const {return _scales[parameterIndex];}
    const double * v(int parameterIndex) const {return _v[parameterIndex];}
    const double * v2(int parameterIndex) const {return _v2[parameterIndex];}
  private:
    int _parameterCount, _modelCount;
    double ** _v;
    double ** _v2;
    double * _scales;
  };

} // namespace DinverCore

#endif // SCALEDMODELS_H
