/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-12-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARENTINDEX_H
#define PARENTINDEX_H

#include "GeneratorModels.h"
#include "BestModels.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class DINVERCORE_EXPORT ParentIndex
  {
  public:
    inline ParentIndex(GeneratorModels * models, const BestIndex& index);
    inline ParentIndex(const ParentIndex& o);
    inline ~ParentIndex();

    int serialNumber() const {return _models->serialNumber();}
    const ActiveModels * activeModels() const {return _models->activeModels();}
    const ScaledModels * scaledModels() const {return _models->scaledModels();}
    const BestIndex& bestIndex() const {return _bestIndex;}
    const ActiveIndex& activeIndex() const {return _activeIndex;}
  private:
    GeneratorModels * _models;
    BestIndex _bestIndex;
    ActiveIndex _activeIndex;
  };

  inline ParentIndex::ParentIndex(GeneratorModels * models, const BestIndex& index)
  {
    _models=models;
    _models->addReference();
    _bestIndex=index;
    _activeIndex=_models->bestModels()->activeIndex(_bestIndex);
  }

  inline ParentIndex::ParentIndex(const ParentIndex& o)
  {
    _models=o._models;
    _models->addReference();
    _bestIndex=o._bestIndex;
    _activeIndex=o._activeIndex;
  }

  inline ParentIndex::~ParentIndex()
  {
    GeneratorModels::removeReference(_models);
  }

} // namespace DinverCore

#endif // PARENTINDEX_H
