/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-09-06
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WAVEFIELDFUNCTION_H
#define WAVEFIELDFUNCTION_H

#include "ArrayCoreDLLExport.h"
#include "Wavefield.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT WavefieldFunction : public AbstractFunction
  {
  public:
    WavefieldFunction(int blockCount, const VectorList<Point2D>& sensors);
    ~WavefieldFunction();

    int parameterSpaceDimension() const;
    void setMaximumShift(Vector<double> maxShift) const;
    void setPrecision(Vector<double> prec) const;
    void setSteering(const FKSteering * s);
    void addObservedWave(double wavenumber, double theta,
                         const WavefieldValues::Observations& obs);

    double value(Vector<double>& x) const;
    void gradient(const Vector<double>&, Vector<double>& grad) const;
    double admissibleStep(const Vector<double>& x, const Vector<double>& step) const;
    void showDetailedMisfit() const;
    void showResults(double minValue, int iterationCount, double frequency) const;

    void checkDerivatives();
    Wavefield& wavefield() {return *_w;}
    const Wavefield& wavefield() const {return *_w;}
    const WavefieldValues::Observations& observations(int index) {return _obs.at(index);}

    bool saveObservations(const QString& fileName) const;
    bool loadObservations(const QString& fileName);
  private:
    Wavefield * _w;
    VectorList<WavefieldValues::Observations> _obs;
  };

} // namespace ArrayCore

#endif // WAVEFIELDFUNCTION_H

