/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SENSORORIENTATIONFUNCTION_H
#define SENSORORIENTATIONFUNCTION_H

#include "ConvFKVertical.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class CrossSpectrumSplit;

  class ARRAYCORE_EXPORT SensorOrientationFunction : public ConvFKVertical
  {
  public:
    SensorOrientationFunction(FKCache * cache);
    ~SensorOrientationFunction();

    void setCrossSpectra(const VectorList<CrossSpectrumSplit *> * cs);
    void setInnerStations(const bool * innerStations) {_innerStations=innerStations;}

    double value(Vector<double>& x) const;
    void gradient(const Vector<double>& x, Vector<double>& grad) const;

    void scan2D(double range, int axis1, int axis2, const QString& fileName);
  private:
    const VectorList<CrossSpectrumSplit *> * _crossSpectra;
    size_t _stationCount;
    mutable Complex _ell;
    mutable ComplexMatrix _psiE, _psiN, _dpsiE, _dpsiN;
    mutable ComplexMatrix _finv;

    VectorList<FKPower *> _powers;
    const bool * _innerStations;
  };

} // namespace ArrayCore

#endif // SENSORORIENTATIONFUNCTION_H

