/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SensorOrientationCapon.h"
#include "FKPeaks.h"
#include "CrossSpectrumSplit.h"

namespace ArrayCore {

  /*!
    \class SensorOrientationCapon SensorOrientationCapon.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SensorOrientationCapon::SensorOrientationCapon(FKCache * cache)
    : ConvFKVertical(cache)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  SensorOrientationCapon::~SensorOrientationCapon()
  {
    TRACE;
  }

  FunctionSearch * SensorOrientationCapon::createSearch(const FKParameters& param)
  {
    GridSearch2D * grid=new GridSearch2D(2);
    grid->setRelativePrecision(0, param.velocityRelativePrecision());
    grid->setRelativePrecision(1, param.velocityRelativePrecision());
    grid->setFunction(this);
    grid->setGrid(param.gridStep(), param.effectiveGridSize());
    steeringInitialization()->setSensorPositionErrors(param);
    steeringInitialization()->setSensorOrientationErrors(param);
    steeringInitialization()->setPhaseShifts(param.gridStep(), param.effectiveGridSize());
    return grid;
  }

  void SensorOrientationCapon::addCrossSpectrum()
  {
    _crossSpectrum->addThreeComponent(steering()->sensorOrientationErrors());
  }

  bool SensorOrientationCapon::invertCrossSpectrum()
  {
    // The main cross-spectral matrix is 3N, in this phase, we need
    // the N matrix for the vertical component.
    int n=_crossSpectrum->array().count();
    int n2=n+n;
    int n31=n2+n-1;
    _fZZ=_crossSpectrum->matrix()->subMatrix(n2, n2, n31, n31);
    _fZZ.invert();
    return true;
  }

  double SensorOrientationCapon::value(const Vector<int>& index) const
  {
    if(isInsideLimits(index)) {
      powerEngine()->setCrossSpectrum(&_fZZ);
      powerEngine()->setHighResolutionValue(oneComponentSteering(index));
      return powerEngine()->value();
    } else {
      return -1.0;
    }
  }

  double SensorOrientationCapon::value(Vector<double>& k) const
  {
    if(isInsideLimits(k)) {
      powerEngine()->setCrossSpectrum(&_fZZ);
      powerEngine()->setHighResolutionValue(oneComponentSteering(k));
      return powerEngine()->value();
    } else {
      return -1.0;
    }
  }

} // namespace ArrayCore

