/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-10
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPACWORKER_H
#define SPACWORKER_H

#include "ArrayWorker.h"
#include "ArrayCoreDLLExport.h"
#include "SPACTaskManager.h"
#include "SPACCrossSpectrum.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SPACWorker : public ArrayWorker
  {
  public:
    SPACWorker(const ArraySelection * array,
               const SPACParameters * param);
    ~SPACWorker();

    void setTaskManager(SPACTaskManager * tm) {ArrayWorker::setTaskManager(tm);}
  protected:
    inline const SPACTaskManager * taskManager() const;

    virtual void process(const VectorList<int>& blocks);
  private:
    SPACCrossSpectrum * crossSpectrum() {return static_cast<SPACCrossSpectrum *>(_crossSpectrum);}
  };

  inline const SPACTaskManager * SPACWorker::taskManager() const
  {
    return static_cast<const SPACTaskManager *>(ArrayWorker::taskManager());
  }

} // namespace ArrayCore

#endif // SPACWORKER_H

