﻿/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-10
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SPACWorker.h"
#include "SPACResults.h"

namespace ArrayCore {

  /*!
    \class SPACWorker SPACWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SPACWorker::SPACWorker(const ArraySelection * array,
                         const SPACParameters * param)
    : ArrayWorker()
  {
    TRACE;
    _crossSpectrum=new SPACCrossSpectrum(array, param);
  }

  /*!
    Description of destructor still missing
  */
  SPACWorker::~SPACWorker()
  {
    TRACE;
  }

  void SPACWorker::process(const VectorList<int>& blocks)
  {
    if(crossSpectrum()->calculate(blocks)) {
      SPACResults::ValueInfo info;
      info.frequencyIndex=crossSpectrum()->timeWindows()->frequencyIndex();
      info.frequency=crossSpectrum()->timeWindows()->frequency().center();
      const TimeWindowList& winList=_crossSpectrum->timeWindows()->list();
      info.time=winList.at(blocks.first()).start();
      int nRejected[3];
      nRejected[0]=0;
      nRejected[1]=0;
      nRejected[2]=0;

      Complex val;
      const SPACParameters& param=*crossSpectrum()->parameters();
      double maxImaginary=param.maximumImaginary();
      SPACResults * res=static_cast<SPACResults *>(taskManager()->results());
      switch(param.method()) {
      case SPACParameters::MSPAC:
        for(int iRing=crossSpectrum()->ringCount()-1; iRing>=0; iRing--) {
          const RingPairs& ring=crossSpectrum()->ring(iRing);
          info.ringIndex=iRing;
          info.distance=0.5*(ring.minRadius()+ring.maxRadius());
          if(crossSpectrum()->mode()==ArrayStations::ThreeComponents) {
            val=ring.radialAutocorr(crossSpectrum());
            if(fabs(val.im())<maxImaginary) {
              res->addValue(Mode::Radial, info, val.re());
            } else {
              nRejected[1]++;
            }
            val=ring.transverseAutocorr(crossSpectrum());
            if(fabs(val.im())<maxImaginary) {
              res->addValue(Mode::Transverse, info, val.re());
            } else {
              nRejected[2]++;
            }
          }
          val=ring.verticalAutocorr(crossSpectrum());
          if(fabs(val.im())<maxImaginary) {
            res->addValue(Mode::Vertical, info, val.re());
          } else {
            nRejected[0]++;
          }
        }
        break;
      case SPACParameters::ESAC:
        info.ringIndex=-1;
        for(int iPair=crossSpectrum()->stationPairCount()-1; iPair>=0; iPair--) {
          const StationPair& pair=crossSpectrum()->stationPair(iPair);
          info.distance=pair.distance();
          if(crossSpectrum()->mode()==ArrayStations::ThreeComponents) {
            val=crossSpectrum()->radialAutocorr(pair.station1(), pair.station2(), pair.azimuth());
            if(fabs(val.im())<maxImaginary) {
              res->addValue(Mode::Radial, info, val.re());
            } else {
              nRejected[1]++;
            }
            val=crossSpectrum()->transverseAutocorr(pair.station1(), pair.station2(), pair.azimuth());
            if(fabs(val.im())<maxImaginary) {
              res->addValue(Mode::Transverse, info, val.re());
            } else {
              nRejected[2]++;
            }
          }
          val=crossSpectrum()->verticalAutocorr(pair.station1(), pair.station2());
          if(fabs(val.im())<maxImaginary) {
            res->addValue(Mode::Vertical, info, val.re());
          } else {
            nRejected[0]++;
          }
        }
        break;
      }
      res->addRejected(info.frequencyIndex, nRejected);
    }
  }

} // namespace ArrayCore

