/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-01-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "OmniFKVertical.h"
#include "FKCrossSpectrum.h"
#include "FKPower.h"

namespace ArrayCore {

#if 0
  /*!
    \class OmniFKVertical OmniFKVertical.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void OmniFKVertical::setGrid(FKGridSearch * g, double step, double size)
  {
    //g->setGrid(0.0, size, step);
    //setAngleGrid();
  }

  /*!
    Usually not called directly. See HRFKTimeWindows
  */
  void OmniFKVertical::setAngleGrid()
  {
    _grid.setFunction(createAngleFunction());
    _grid.setGrid(_crossSpectrum->rotationStepCount());
  }

  AbstractFunction * OmniFKVertical::createAngleFunction() const
  {
    return new Angle(cache());
  }

  /*!
    Automatically called by GridSearch upon initialization.
    If returned value is false, grid is assumed to be already initialized.
  */
  bool OmniFKVertical::initGrid(int n)
  {
    if(_gridCache->isEmpty(FKCache::OneComponent)) {
      n*=_crossSpectrum->rotationStepCount();
      App::log(tr("Caching steering vectors for 1-component (omni)... (%1 values)\n").arg(n) );
      _gridCache->resize(FKCache::OneComponent, n);
      _gridCache->reportCacheVolume(FKCache::OneComponent, n,
                                    FKSteeringOneComponent::sizeFactor);
      return true;
    } else {
      return false;
    }
  }

  void OmniFKVertical::initGrid(const Point& kell, int index)
  {
    int n=_crossSpectrum->rotationStepCount();
    double da=_crossSpectrum->rotationStep();
    double a;
    Point2D k;
    for(int i=0; i<n; i++) {
      a=(double)i*da;
      k.setX(kell.x()*::cos(a));
      k.setY(kell.x()*::sin(a));
      FKSteeringOneComponent::init(_gridCache, index*n+i , k);
    }
  }

  double OmniFKVertical::value(const Point& kell, int index) const
  {
    double k2=kell.x()*kell.x();
    if(k2>minimumK2() && k2<maximumK2()) {
      int n=_crossSpectrum->rotationStepCount();
      int startIndex=index*n;
      int endIndex=startIndex+n;
      double sum=0.0;
      for(int i=startIndex; i<endIndex; i++) {
        FKPower p(&FKSteeringOneComponent::cache(_gridCache, i));
        p.setHighResolutionValue(_crossSpectrum->matrix());
        sum+=p.value();
      }
      return sum;
    } else {
      return -1.0;
    }
  }

  /*!
    \a kell.x() is the wavenumber absolute value
    \a kell.y() is not used
    \a kell.z() is not used

    A test with azimuthal stack
  */
  double OmniFKVertical::value(const Point& kell) const
  {
    double k2=kell.x()*kell.x();
    if(k2>minimumK2() && k2<maximumK2()) {
      Point2D k;
      int n=_crossSpectrum->rotationStepCount();
      double da=_crossSpectrum->rotationStep();
      double a;
      double sum=0.0;
      FKSteeringOneComponent * s=static_cast<FKSteeringOneComponent *>(_steering);
      FKPower p(s);
      for(int i=0; i<n; i++) {
        a=(double)i*da;
        k.setX(kell.x()*::cos(a));
        k.setY(kell.x()*::sin(a));
        s->initValue(k);
        p.setHighResolutionValue(_crossSpectrum->matrix());
        sum+=p.value();
      }
      return sum;
      /*Angle * function=static_cast<Angle *>(_grid.function());
      function->setWaveNumber(kell);
      _grid.localMax(INT_MAX, 0.0, 50);
      FunctionMaximaIterator it;
      double value=0.0;
      int nPeaks=0;
      for(it=_grid.begin(); it!=_grid.end(); ++it) {
        value+=(*it)->value();
        nPeaks++;
      }*/
      //return value/(double)nPeaks;
      //return (double)nPeaks;

    } else {
      return -1.0;
    }
  }

  /*!
    Return true if \a k is close to the limits (<1% relative).
    \a frequency is used only for reporting.
  */
  bool OmniFKVertical::isOnLimit(const Point& k, double frequency) const
  {
    return AbstractFKFunction::isOnLimit(Point(k.x(), 0.0, 0.0), frequency);
  }

  double OmniFKVertical::Angle::value(const Point& a, int index) const
  {
    Q_UNUSED(index)
    return value(a);
  }

  double OmniFKVertical::Angle::value(const Point& a) const
  {
    ComplexMatrix e, eh;
    Point2D k;
    k.setX(_kell.x()*::cos(a.x()));
    k.setY(_kell.x()*::sin(a.x()));
    FKSteeringOneComponent * s=static_cast<FKSteeringOneComponent *>(_steering);
    FKPower p(s);
    s->initValue(k);
    p.setHighResolutionValue(_crossSpectrum->matrix());
    return p.value();
  }
#endif
} // namespace ArrayCore

