/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-30
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ORAWorker.h"

namespace ArrayCore {

#define INSPECT_FREQUENCY 4.0271
//#define INSPECT_TIME "20000101000000.00"

/*!
    \class ORAWorker ORAWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ORAWorker::ORAWorker(const ArraySelection * array,
                       const ArrayParameters * param)
    : ArrayWorker()
  {
    TRACE;
    _crossSpectrum=new ORACrossSpectrum(array, param);
  }

  /*!
    Description of destructor still missing
  */
  ORAWorker::~ORAWorker()
  {
    TRACE;
  }

  void ORAWorker::process(const VectorList<int>& blocks)
  {
    double f=_crossSpectrum->timeWindows()->frequency().center();
#ifdef INSPECT_FREQUENCY
    if(fabs(f-INSPECT_FREQUENCY)<0.001) {
      App::log(tr("Inspect selected frequency %1 Hz\n").arg(f));
    } else {
      return;
    }
#endif
    const TimeWindowList& winList=_crossSpectrum->timeWindows()->list();
    const DateTime& currentTime=winList.at(blocks.first()).start();
#ifdef INSPECT_TIME
    DateTime t;
    t.fromString(INSPECT_TIME);
    if(fabs(currentTime.secondsTo(t))<0.1) {
      App::log(tr("Inspect time window starting at %1\n").arg(currentTime.toString()));
    } else {
      return;
    }
#endif
    if(crossSpectrum()->calculate(blocks)) {
      int i1=0;
      int i2=1;
      double theta0=crossSpectrum()->defaultAngle(i1, i2);
      App::log(tr("Radial direction %1\n").arg(Angle::radiansToDegrees(theta0)));
      QFile f(currentTime.toString());
      f.open(QIODevice::WriteOnly);
      QTextStream s(&f);
      s << "x y val\n";
      for(double dt1=-M_PI/18.0; dt1<=M_PI/18.0; dt1+=M_PI/1800.0) {
        for(double dt2=-M_PI/18.0; dt2<=M_PI/18.0; dt2+=M_PI/1800.0) {
          s << Angle::radiansToDegrees(dt1) << " "
            << Angle::radiansToDegrees(dt2) << " "
            << crossSpectrum()->value(i1, i2, theta0+dt1*0, theta0+dt2*0) << Qt::endl;
        }
      }
      f.close();
    }
  }

} // namespace ArrayCore

