/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-30
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ORATOOL_H
#define ORATOOL_H

#include "AbstractArrayTool.h"
#include "ArrayCoreDLLExport.h"
#include "ORATaskManager.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ORATool : public AbstractArrayTool
  {
  public:
    ORATool(QObject * parent);
    ~ORATool();

    bool setSubPool(SubSignalPool *subPool);

    inline const ORAParameters * parameters() const;
    inline  ORAParameters * parameters();
  protected:
    QString toolName() {return tr("SPAC Array analysis");}
    ParallelTaskManager * createLoop() {return new ORATaskManager(array());}
  };

  inline const ORAParameters * ORATool::parameters() const
  {
    return static_cast<const ORAParameters *>(AbstractArrayTool::parameters());
  }

  inline ORAParameters * ORATool::parameters()
  {
    return static_cast<ORAParameters *>(AbstractArrayTool::parameters());
  }

} // namespace ArrayCore

#endif // ORATOOL_H

