/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-30
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ORATool.h"

namespace ArrayCore {

  /*!
    \class ORATool ORATool.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ORATool::ORATool(QObject * parent)
    : AbstractArrayTool(parent)
  {
    TRACE;
    setParameters(new ORAParameters);
  }

  /*!
    Description of destructor still missing
  */
  ORATool::~ORATool()
  {
    TRACE;
  }

  bool ORATool::setSubPool(SubSignalPool *subPool)
  {
    TRACE;
    if(AbstractArrayTool::setSubPool(subPool)) {
      switch (array()->components()) {
      case StationSignals::AllComponent:
        break;
      default:
        Message::warning(MSG_ID, tr("Checking components"),
                              tr( "Only three-component signals are allowed."),
                              Message::cancel());
        return false;
      }
      return true;
    } else {
      return false;
    }
  }

} // namespace ArrayCore

