/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-02-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "KNullSolver.h"

namespace ArrayCore {

  /*!
    \class KNullSolver KNullSolver.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  KNullSolver::KNullSolver(const VectorList<Point2D>& stations)
  {
    TRACE;
    _function=new TheoreticalFKNull(stations);
  }

  /*!
    Description of destructor still missing
  */
  KNullSolver::~KNullSolver()
  {
    TRACE;
    delete _function;
  }

  void KNullSolver::collect(const FKParameters& param, double threshold)
  {
    GridSearch2D grid(2);
    grid.setRelativePrecision(0, param.velocityRelativePrecision());
    grid.setRelativePrecision(1, param.velocityRelativePrecision());
    grid.setFunction(_function);
    grid.setGrid(param.gridStep(), param.gridSize());
    _function->setGridStep(param.gridStep());
    grid.localMax(INT_MAX, 1.0/threshold, 0.0);
    _points.clear();
    FunctionMaximaIterator it;
    for(it=grid.begin(); it!=grid.end(); ++it) {
      const FunctionSearchMaximum& m=**it;
      const Vector<double>& k=m.position();
      if(k.length(0, 1)<param.kmax()) {
        _points.append(Point2D(k[0], k[1]));
      }
    }
    grid.takeFunction();
    // Sort results by the distance to the origin
    std::sort(_points.begin(), _points.end(), lengthLessThan);
    App::log(tr("Found %1 null points (<%2) in theoretical array response.\n")
             .arg(_points.count()).arg(threshold));
  }

  bool KNullSolver::lengthLessThan(const Point2D& p1, const Point2D& p2)
  {
    return p1.length()<p2.length();
  }

} // namespace ArrayCore

