/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-12
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKPower.h"
#include "ArraySelection.h"

namespace ArrayCore {

  /*!
    \class FKPower FKPower.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  FKPower::FKPower(int stationCount, int matrixSizeFactor)
    : _fe(matrixSizeFactor*stationCount, 0.0),
      _ddfe(matrixSizeFactor*stationCount, 0.0),
      _e(matrixSizeFactor*stationCount, 0.0),
      _exi(matrixSizeFactor*stationCount, 0.0),
      _edxi(matrixSizeFactor*stationCount, 0.0),
      _re(matrixSizeFactor*stationCount, 0.0),
      _re2(matrixSizeFactor*stationCount, 0.0),
      _r(matrixSizeFactor*stationCount, 0.0),
      _eGrid(stationCount, nullptr)
  {
    _p2=0.0;
    _dp=0.0;
    _q=nullptr;
    _f=nullptr;
    _factorN=1.0/(stationCount*stationCount);
  }

  FKPower::~FKPower()
  {
  }

  QString FKPower::toString(char format, int precision) const
  {
    QString str;
    str+="e="+_e.toOctaveString(format, precision)+";\n";
    str+="f="+_f->toOctaveString(format, precision)+";\n";
    str+="fe="+_fe.toOctaveString(format, precision)+";\n";
    str+="p="+_p.toString(format, precision)+";\n";
    return str;
  }

  void FKPower::toOctaveFile(const QString& fileName) const
  {
    QFile f(fileName);
    if(!f.open(QIODevice::Append)) {
      App::log(tr("Cannot write to %1\n").arg(fileName));
      return;
    }
    QTextStream s(&f);
    s << "e=" << _e.toOctaveString('g', 20) << ";" << Qt::endl;
    s << "f=" << _f->toOctaveString('g', 20) << ";" << Qt::endl;
    s << "fe=" << _fe.toOctaveString('g', 20) << ";" << Qt::endl;
    s << "p=" << _p.toString('g', 20) << ";" << Qt::endl;
    f.close();
  }

} // namespace ArrayCore
