/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-11-22
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKCache.h"

namespace ArrayCore {

  /*!
    \class FKCache FKCache.h
    \brief Steering matrix for various FK methods

    Centralized storage for pre-computed steering vectors.

  */

  /*!
    Description of constructor still missing
  */
  FKCache::FKCache(const ArraySelection * array)
  {
    TRACE;
    _array=array;
    _passiveSteering=nullptr;
    _beampattern=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  FKCache::~FKCache()
  {
    TRACE;
    delete _passiveSteering;
    delete _beampattern;
  }

  void FKCache::setPassiveSteering()
  {
    if(!_passiveSteering) {
      _passiveSteering=new FKSteering(_array);
      _beampattern=new TheoreticalFK(_array->relativePos());
    }
  }

} // namespace ArrayCore

