/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CROSSSPECTRUMSPLIT_H
#define CROSSSPECTRUMSPLIT_H

#include <QGpCoreMath.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT CrossSpectrumSplit
  {
  public:
    CrossSpectrumSplit();
    ~CrossSpectrumSplit();

    void addWaveNumber(const Vector<double>& k);
    void clearWavenumbers() {_kx.clear(); _ky.clear();}

    void setMatrix(const ComplexMatrix& f);

    size_t stationCount() const {return _fZZ.rowCount()/3;}

    int wavenumberCount() const {return _kx.count();}
    double kx(int index) const {return _kx.at(index);}
    double ky(int index) const {return _ky.at(index);}

    const ComplexMatrix& fZZ() const {return _fZZ;}
    const ComplexMatrix& fEE() const {return _fEE;}
    const ComplexMatrix& fEN() const {return _fEN;}
    const ComplexMatrix& fNE() const {return _fNE;}
    const ComplexMatrix& fNN() const {return _fNN;}
    const ComplexMatrix& fEZ() const {return _fEZ;}
    const ComplexMatrix& fZE() const {return _fZE;}
  private:
    VectorList<double> _kx, _ky;
    ComplexMatrix _fZZ, _fEE, _fEN, _fNE, _fNN, _fEZ, _fZE;
  };

} // namespace ArrayCore

#endif // CROSSSPECTRUMSPLIT_H

