/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-21
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CONVTHREECOMPONENTXIFUNCTION_H
#define CONVTHREECOMPONENTXIFUNCTION_H

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ConvThreeComponentXiFunction
  {
  public:
    ConvThreeComponentXiFunction();

    void setParameters(double tx, double ellh, double ellz, double xix);
    double value(double xi) const;
    void solve();
    double refineRoot(double xi1, double f1, double xi2) const;
    void refineMinimum(double xi1, double xi2);

    double solution1() const {return _xir1;}
    double solution2() const {return _xir2;}
    double verticalNoise(double xir) const;
    double horizontalNoise(double xir) const;
    void printFunction() const;
    void check();
  private:
    double _tx;
    double _ellh, _ellz, _invellz;
    double _xix, _cxix, _sxix, _cxix2, _sxix2;
    double _precision;

    double _xir1, _xir2;
  };

} // namespace ArrayCore

#endif // CONVTHREECOMPONENTXIFUNCTION_H

