/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-22
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CONVELLIPTICITYENGINE_H
#define CONVELLIPTICITYENGINE_H

#include "AbstractEllipticityEngine.h"
#include "ArrayCoreDLLExport.h"
#include "ConvThreeComponentXiFunction.h"

namespace ArrayCore {

  class ConvFKRayleigh;
  class ConvFKRayleighRadial;
  class ConvFKRayleighVertical;

  class ARRAYCORE_EXPORT ConvEllipticityEngine : public AbstractEllipticityEngine
  {
  public:
    ConvEllipticityEngine(FKCache * cache, const FKParameters& param);
    ~ConvEllipticityEngine();

    double radialPower(Vector<double>& kell,
                       FKCrossSpectrum * crossSpectrum);
    double radialWavenumberNormalizedConcavity(Vector<double>& kell);
    double radialConcavity(Vector<double>& kell, int axis);
    double verticalPower(Vector<double>& kell,
                         FKCrossSpectrum * crossSpectrum);
    double verticalWavenumberNormalizedConcavity(Vector<double>& kell);
    double verticalConcavity(Vector<double>& kell, int axis);
  protected:
    ConvFKRayleighRadial * _rayleighRadial;
    ConvFKRayleighVertical * _rayleighVertical;
  };

} // namespace ArrayCore

#endif // CONVELLIPTICITYENGINE_H

