/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-22
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ConvEllipticityEngine.h"
#include "ConvFKRadial.h"
#include "ConvFKRayleighRadial.h"
#include "ConvFKRayleighVertical.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class ConvEllipticityEngine ConvEllipticityEngine.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ConvEllipticityEngine::ConvEllipticityEngine(FKCache * cache, const FKParameters& param)
    : AbstractEllipticityEngine(param)
  {
    _vertical=new ConvFKVertical(cache);
    _vertical->initialize(param);
    _radial=new ConvFKRadial(cache);
    _radial->initialize(param);

    _rayleighRadial=new ConvFKRayleighRadial(cache);
    _rayleighRadial->initialize(param);
    _rayleighVertical=new ConvFKRayleighVertical(cache);
    _rayleighVertical->initialize(param);
  }

  /*!
    Description of destructor still missing
  */
  ConvEllipticityEngine::~ConvEllipticityEngine()
  {
    delete _rayleighRadial;
    delete _rayleighVertical;
  }

  double ConvEllipticityEngine::radialPower(Vector<double>& kell,
                                            FKCrossSpectrum * crossSpectrum)
  {
    _rayleighRadial->setCrossSpectrum(crossSpectrum->matrix());
    return _rayleighRadial->value(kell);
  }

  double ConvEllipticityEngine::radialWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    Q_UNUSED(kell);
    TODO_WARNING;
    return 0.0;
  }

  double ConvEllipticityEngine::radialConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighRadial->concavity(kell, axis);
  }

  double ConvEllipticityEngine::verticalPower(Vector<double>& kell,
                                              FKCrossSpectrum * crossSpectrum)
  {
    _rayleighVertical->setCrossSpectrum(crossSpectrum->matrix());
    return _rayleighVertical->value(kell);
  }

  double ConvEllipticityEngine::verticalWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    Q_UNUSED(kell);
    TODO_WARNING;
    return 0.0;
  }

  double ConvEllipticityEngine::verticalConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighVertical->concavity(kell, axis);
  }

} // namespace ArrayCore

