/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-10
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYWORKER_H
#define ARRAYWORKER_H

#include <QGpCoreTools.h>

#include "ArrayCoreDLLExport.h"
#include "ArrayTaskManager.h"
#include "ArrayCrossSpectrum.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ArrayWorker : public ParallelTaskWorker
  {
  public:
    ArrayWorker();
    ~ArrayWorker();

    void setTaskManager(ArrayTaskManager * tm) {ParallelTaskWorker::setTaskManager(tm);}
  protected:
    inline ArrayTaskManager * taskManager() const;

    void process(ParallelTask * t);
    virtual void process(const VectorList<int>& blocks)=0;

    ArrayCrossSpectrum * _crossSpectrum;
  };

  inline ArrayTaskManager * ArrayWorker::taskManager() const
  {
    return static_cast<ArrayTaskManager *>(ParallelTaskWorker::taskManager());
  }

} // namespace ArrayCore

#endif // ARRAYWORKER_H

