/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-11-29
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYTASK_H
#define ARRAYTASK_H

#include "ArrayCoreDLLExport.h"
#include "ArrayTimeWindows.h"

#define ARRAY_TASK_TIMING

namespace ArrayCore {

  class ArrayTaskManager;

  class ARRAYCORE_EXPORT ArrayTask: public ParallelTask
  {
    Q_OBJECT
  public:
    ArrayTask(ArrayTaskManager * manager,
              int taskIndex,
              const ArraySelection * array,
              const SparseKeepSignal * keep,
              const ArrayParameters * param);
    ~ArrayTask();

    void init();
    const ArrayTimeWindows * timeWindows() const {return &_timeWindows;}
  protected:
    ArrayTimeWindows _timeWindows;
  };

} // namespace ArrayCore

#endif // ARRAYTASK_H

