/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-02
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYCROSSSPECTRUM_H
#define ARRAYCROSSSPECTRUM_H

#include "ArrayCoreDLLExport.h"
#include "ArrayTimeWindows.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ArrayCrossSpectrum
  {
  public:
    ArrayCrossSpectrum(const ArraySelection * array,
                       const ArrayParameters * param);
    virtual ~ArrayCrossSpectrum();

    void setTimeWindows(const ArrayTimeWindows * tw) {_timeWindows=tw;}
    const ArrayTimeWindows * timeWindows() const {return _timeWindows;}

    const ArraySelection& array() const {return _array;}
    const ArrayParameters * parameters() const {return _parameters;}
    int stationCount() const {return _stations.count();}
    ArrayStations::Mode mode() const {return _mode;}

    void resetMatrix();
    virtual void addVertical();
    void addHorizontal() {addHorizontal(*_matrix);}
    void meanMatrix(int nBlocks);

    const ComplexMatrix * matrix() const {return _matrix;}
    ComplexMatrix * matrix() {return _matrix;}

    bool lockTimeWindow(const TimeRange& win);
    void unlockTimeWindow();
  protected:
    void addHorizontal(ComplexMatrix& covmat);
    void setStations(const ArraySelection * array);

    ArraySelection _array;
    QList<ArrayStationSignals *> _stations;
    const ArrayTimeWindows * _timeWindows;
    const ArrayParameters * _parameters;
    ArrayStations::Mode _mode;
    int _verticalIndex, _northIndex, _eastIndex;

    ComplexMatrix * _matrix;
  };

} // namespace ArrayCore

#endif // ARRAYCROSSSPECTRUM_H

