/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-09-03
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveFKToolSet.h"
#include "ActiveFKTool.h"
#include "ActiveFKTaskManager.h"

namespace ArrayCore {

  /*!
    \class ActiveFKToolSet ActiveFKToolSet.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ActiveFKToolSet::ActiveFKToolSet(QObject * parent)
    : AbstractTool(parent)
  {
    TRACE;
    setParameters(new ActiveFKParameters);
  }

  ActiveFKToolSet::~ActiveFKToolSet()
  {
    TRACE;
    int n=_subTools.count();
    for(int i=0; i<n; i++) {
      FKTool * tool=_subTools.at(i);
      delete tool->subPool();
    }
  }

  bool ActiveFKToolSet::setSubPool(SubSignalPool * subPool)
  {
    if(!AbstractTool::setSubPool(subPool)) {
      return false;
    }
    // Gather all sources
    QHash<const SeismicEvent *, SubSignalPool *> sourceSignals;
    sourceSignals=subPool->associateSources();
    // Sort sources by increasing time
    QList<const SeismicEvent *> sources=sourceSignals.keys();
    std::sort(sources.begin(), sources.end(), SeismicEvent::lessThan);

    int n=sources.count();
    bool allOK=true;
    for(int i=0; i<n; i++) {
      ActiveFKTool * tool=new ActiveFKTool(this);
      tool->setSource(sources.at(i));
      if(!tool->setSubPool(sourceSignals.value(sources.at(i)))) {
        allOK=false;
      }
      _subTools.append(tool);
    }
    return allOK;
  }

  void ActiveFKToolSet::start(int, bool)
  {
    int n=_subTools.count();
    for(int i=0; i<n; i++) {
      FKTool * tool=_subTools.at(i);
      *tool->parameters()=*parameters();
      if(tool->setLoop()) {
        // TODO: implement usual FK picking ????

      }
    }
  }

  const IrregularGrid2D * ActiveFKToolSet::grid(int index, int threadCount)
  {
    ActiveFKTool * tool=_subTools.at(index);
    *tool->parameters()=*parameters();
    if(tool->setLoop()) {
      tool->start(threadCount, true);
      tool->waitFinished(0);
      return tool->grid();
    } else {
      return nullptr;
    }
  }

  ParallelTaskManager * ActiveFKToolSet::loop(int index) const
  {
    ActiveFKTool * tool=_subTools.at(index);
    return tool->loop();
  }

} // namespace ArrayCore

