/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-09-17
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVECONVFKVERTICAL_H
#define ACTIVECONVFKVERTICAL_H

#include "AbstractFKFunction.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveConvFKVertical : public AbstractFKFunction
  {
  public:
    ActiveConvFKVertical(FKCache * cache);
    ~ActiveConvFKVertical();

    void initialize(const FKParameters& param);
    FunctionSearch * createSearch(const FKParameters& param);

    bool setSource(const VectorList<int>& blocks);

    void resetCrossSpectrum();
    void addCrossSpectrum();
    void meanCrossSpectrum(int nBlocks);
    void addIncoherentNoise(double, double vertical);

    double value(Vector<double>& k) const;

    FK_ACTIVE_STEERING
  };

} // namespace ArrayCore

#endif // ACTIVECONVFKVERTICAL_H

