/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-04
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "AbstractEllipticityEngine.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class AbstractEllipticityEngine AbstractEllipticityEngine.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  AbstractEllipticityEngine::AbstractEllipticityEngine(const FKParameters& param)
  {
    _kmin=param.kmin();
    _gridStep=param.gridStep();
    _grid.setRelativePrecision(0, param.velocityRelativePrecision());
    _grid.setRelativePrecision(1, param.velocityRelativePrecision());

    _xi=std::numeric_limits<double>::quiet_NaN();
    _RzOverN=std::numeric_limits<double>::quiet_NaN();
    _RhOverN=std::numeric_limits<double>::quiet_NaN();

    _vertical=nullptr;
    _radial=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  AbstractEllipticityEngine::~AbstractEllipticityEngine()
  {
    delete _vertical;
    delete _radial;
  }

} // namespace ArrayCore

