/***************************************************************************
**
**  This file is part of warangps.
**
**  warangps is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  warangps is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-30
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "DistanceTableModel.h"

/*!
  \class DistanceTableModel DistanceTableModel.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
DistanceTableModel::DistanceTableModel()
    : QAbstractTableModel()
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
DistanceTableModel::~DistanceTableModel()
{
  TRACE;
}

int DistanceTableModel::rowCount(const QModelIndex & ) const
{
  TRACE;
  return 0;
}

/*!
  Currently return only 1 but may evolve in the future
*/
int DistanceTableModel::columnCount(const QModelIndex &) const
{
  TRACE;
  return 3;
}

QVariant DistanceTableModel::data(const QModelIndex &index, int role) const
{
  TRACE;
  if( !index.isValid()) return QVariant();
  //GpsStation * stat=_stations->at(index.row());
  switch (role) {
  case Qt::DisplayRole:
    switch(index.column()) {
    default:
      return QVariant();
    }
  default:
    return QVariant();
  }
}

bool DistanceTableModel::setData(const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  Q_UNUSED(value);
  TODO_WARNING;
  if(index.column()==1 && role==Qt::EditRole) {
    //_stations->at(index.row())->setOperatorName(value.toString());
    return true;
  } else {
    return false;
  }
}
QVariant DistanceTableModel::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    switch (section) {
    case 0: return tr("Pair of stations");
    case 1: return tr("Distance");
    case 2: return tr("Stddev");
    default: return QVariant();
    }
  } else {
    return section+1;
  }
}

Qt::ItemFlags DistanceTableModel::flags(const QModelIndex & index) const
{
  if(index.column()==1) {
    return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;
  } else {
    return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
  }
}
