/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-20
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WARANWIDGET_H
#define WARANWIDGET_H

#include <QGpGuiTools.h>
#include <ArrayCore.h>

#include "ui_WaranWidget.h"

class RealTimeArrayManager;

class WaranWidget : public QWidget, public Ui::WaranWidget
{
  Q_OBJECT
public:
  WaranWidget(QWidget * parent=nullptr);
  ~WaranWidget();

  void setfrequencyBandwidth(double fbw) {_frequencyBandwidth=fbw;}
protected:
  void closeEvent(QCloseEvent * e);
private slots:
  void setStations();
  void setHVWindowLength();
  void setArrayWindowLength();
  void setSamplingParameters();
  void setKmin(double k);
  void setKmax(double k);
  void updateDataProcess();
  void updateDataDisplay();
  void dataChanged(Signal * sig, GeopsyCore::TimeRange tr);
  void on_loadCoordinateButton_clicked();
  void on_saveCoordinateButton_clicked();
  void on_relativePositionButton_clicked();
  void startArrayProcess();
  void stopArrayProcess();
  void startHVProcess();
  void stopHVProcess();
private:
  void add(Signal * sig);
  void lockSubPool();
  void unlockSubPool();
  bool setCoordinates(const ColumnTextParser * parser);
  void updateArrayMap();
  void updateCoArrayMap();
  void updateArrayResponse();
  bool arrayParameterChanged();
  bool hvParameterChanged();
  void initResultGraph(AxisWindow * g, IrregularGrid2DPlot *& gridLayer,
                       DispersionLimitLayer *& dispLimits);

  QList<Station *> _stations;
  QString _processingUnitAddress;

  UtmZone _utmZone;
  QSet<QString> _stationNames;
  QMap<QString, Point> _stationCoordinates;
  ArrayStations _array;
  SubSignalPool _signals;
  double _frequencyBandwidth;
  RealTimeArrayManager * _arrayProcess;
  //RealTimeHVManager * _hvProcess;

  QTimer _displayUpdateTimer, _processUpdateTimer;
  DateTime _maximumTime;

  IrregularGrid2DPlot * _fkGridLayer, * _hrfkGridLayer, * _spacGridLayer;
  DispersionLimitLayer * _fkDispLimits, * _hrfkDispLimits, * _spacDispLimits;
};

#endif // WARANWIDGET_H
