/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-08
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TapeCoordinateDelegate.h"
#include "TapePoint.h"

/*!
  \class TapeCoordinateDelegate TapeCoordinateDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
TapeCoordinateDelegate::TapeCoordinateDelegate(QObject * parent)
  : ItemDelegate(parent)
{
  TRACE;
}

QWidget * TapeCoordinateDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                               const QModelIndex & index) const
{
  TRACE;
  switch (index.column()) {
  case 3: {
      QComboBox * w=createComboBox(parent);
      w->addItem(TapePoint::convertType(TapePoint::Fixed));
      w->addItem(TapePoint::convertType(TapePoint::North));
      w->addItem(TapePoint::convertType(TapePoint::Eastward));
      w->addItem(TapePoint::convertType(TapePoint::Free));
      w->addItem(TapePoint::convertType(TapePoint::Prior));
      return w;
    }
  default: {
      QDoubleSpinBox * w=createDoubleSpinBox(parent);
      w->setMinimum(-std::numeric_limits<double>::infinity());
      w->setMaximum(std::numeric_limits<double>::infinity());
      w->setSuffix(" m");
      w->setDecimals(3);
      w->setSingleStep(0.01);
      return w;
    }
  }
  return 0;
}
