/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DISTANCEDELEGATE_H
#define DISTANCEDELEGATE_H

#include <QGpGuiTools.h>

class DistanceDelegate : public ItemDelegate
{
  Q_OBJECT
public:
  DistanceDelegate(QObject * parent, SortedStringList * pointNames);

  QWidget * createEditor(QWidget * parent, const QStyleOptionViewItem &,
                         const QModelIndex & index) const;
  void setModelData(QWidget *editor, QAbstractItemModel *model,
                    const QModelIndex &index) const;
private:
  SortedStringList * _pointNames;
};

#endif // DISTANCEDELEGATE_H
