/***************************************************************************
**
**  This file is part of spac2disp.
**
**  spac2disp is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  spac2disp is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-06-26
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPAC3CFORWARD_H
#define SPAC3CFORWARD_H

#include <DinverCore.h>
#include <QGpCoreWave.h>

class Spac3CForward : public AbstractForward
{
   TRANSLATIONS("Spac3CForward")
public:
   Spac3CForward();
   Spac3CForward(const Spac3CForward& o);
  ~Spac3CForward();

  void setCurves(const AutocorrCurves& autocorr);
  void setFrequency(int i);
  int omegasCount() const {return _autocorrFactory->x()->count();}
  double omega(int i) const {return _autocorrFactory->vertical(0).x(i);}

  void setModel(const double * model);

  double vertical(int ringIndex) const;
  double radial(int ringIndex) const;
  double transverse(int ringIndex) const;

  virtual AbstractForward * clone() const;
  virtual double misfit(double * model, bool& ok);
private:
  int _iOmega;
  AutocorrCurves _curves;
  AutocorrFactory * _autocorrFactory;
  DispersionFactory * _dispFactory;
  QList<ModalCurve> _curveList;
  QList<int> _curveIndexes;
};

#endif // SPAC3CFORWARD_H
