/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-05-29
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QTextStream>

#include <QGpCoreTools.h>
#include "FKMaxEntry.h"

/*!
  \class FKMaxEntry FKMaxEntry.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool FKMaxEntry::readLine(QTextStream& s)
{
  TRACE;
  QString line;
  do {
    line=s.readLine();
  } while(!line.isEmpty() && line[0]=='#');
  if(!line.isEmpty()) {
    const QChar * ptr=0;
    bool ok=true;
    StringSection field,fields(line);
    field=fields.nextField(ptr);
    _time=field.toDouble(ok);
    field=fields.nextField(ptr);
    _x=field.toDouble(ok);
    field=fields.nextField(ptr);
    _slowness=field.toDouble(ok);
    field=fields.nextField(ptr);
    _azimuth=field.toDouble(ok);
    fields.nextField(ptr); // Azimuth
    field=fields.nextField(ptr);
    _relativePower=field.toDouble(ok);
    field=fields.nextField(ptr);
    _absolutePower=field.toDouble(ok);
    field=fields.nextField(ptr);
    if(field.isValid())
      _selected=field.toInt(ok)>0 ? true : false;
    else
      _selected=true; // compatibility with format out of Geopsy and Cap
    _slowness*=0.001;
    return ok;
  } else {
    return false;
  }
}

void FKMaxEntry::writeLine(QTextStream& s) const
{
  TRACE;
  static const QString fmt("%1 %2 %3 %4 %5 %6 %7 %8");
  double a=90.0-_azimuth;
  if(a<0.0) a+=360.0;
  s << fmt.arg(_time).arg(_x).arg(_slowness*1000.0).arg(_azimuth).arg(a)
          .arg(_relativePower).arg(_absolutePower).arg(_selected) << Qt::endl;
}

bool FKMaxEntry::isHeaderLine(QString f)
{
  TRACE;
  if(f.contains("secondsfromstart|cfreq|slow|az|math-phi|semblance|beampow")) return true;
  if(f.contains("secondsfromstart|cfreq|slow|baz|math-phi|semblance|beampow")) return true;
  if(f.contains("secondsfromstart|cfreq|slow/appvel|baz|math-phi|semblance|beampow")) return true;
  return false;
}

QByteArray FKMaxEntry::fields()
{
  TRACE;
  return "seconds from start | cfreq | slow | az | math-phi | semblance | beampow";
}

void FKMaxEntry::writeHeader(QTextStream& s) const
{
  TRACE;
  s << "# File generated by max2curve, FK post-processing\n";
  s << QString( "# %1 | selected").arg(fields().data()) << Qt::endl;
}

void FKMaxEntry::includePower(double& minRelPow, double& maxRelPow, double& minAbsPow, double& maxAbsPow)
{
  TRACE;
  if(_relativePower < minRelPow) minRelPow=_relativePower;
  if(_relativePower > maxRelPow) maxRelPow=_relativePower;
  if(_absolutePower < minAbsPow) minAbsPow=_absolutePower;
  if(_absolutePower > maxAbsPow) maxAbsPow=_absolutePower;
}
