/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-07-09
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QTextStream>

#include <QGpCoreTools.h>
#include "CurveMaxEntry.h"

/*!
  \class CurveMaxEntry CurveMaxEntry.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool CurveMaxEntry::operator<(const MaxEntry& o) const
{
  TRACE;
  if(x()<o.x()) return true;
  else if(x()>o.x()) return false;
  const CurveMaxEntry& m=static_cast<const CurveMaxEntry&>(*this);
  const CurveMaxEntry& mo=static_cast<const CurveMaxEntry&>(o);
  if(m._y>mo._y) return true;
  else return false;
}

bool CurveMaxEntry::readLine(QTextStream& s)
{
  TRACE;
  QString line;
  do {
    line=s.readLine();
  } while(!line.isEmpty() && line[0]=='#');
  if(!line.isEmpty()) {
    bool ok=true;
    const QChar * ptr=0;
    StringSection field,fields(line);
    field=fields.nextField(ptr);
    _x=field.toDouble(ok);
    field=fields.nextField(ptr);
    _y=field.toDouble(ok);
    field=fields.nextField(ptr);
    if(field.isValid())
      _selected=field.toBool(ok);
    else
      _selected=true;
    _time=0.0;
    return ok;
  } else {
    return false;
  }
}

void CurveMaxEntry::writeLine(QTextStream& s) const
{
  TRACE;
  static const QString fmt("%1 %2 %3\n");
  s << fmt.arg(_x).arg(_y).arg(_selected) << Qt::endl;
}

bool CurveMaxEntry::isHeaderLine(QString f)
{
  TRACE;
  return f.contains("x|y");
}

QByteArray CurveMaxEntry::fields()
{
  TRACE;
  return "x | y";
}

void CurveMaxEntry::writeHeader(QTextStream& s) const
{
  TRACE;
  s << "# File generated by max2curve, generic curve processing\n";
  s << QString( "# %1 | selected").arg(fields().data()) << Qt::endl;
}
