/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-06-01
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#include <GeopsyCore.h>
#include <QGpGuiTools.h>

#include "HVTFAParameters.h"
#include "ToolHVTFAd.h"

/*!
  \class HVTFAParameters HVTFAParameters.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
HVTFAParameters::HVTFAParameters()
  : AbstractParameters()
{
  TRACE;
}

/*!
  Description of constructor still missing
*/
HVTFAParameters::HVTFAParameters(const HVTFAParameters& o)
  : AbstractParameters(o),
    _timeRange(o._timeRange),
    _frequencySampling(o._frequencySampling),
    _wavelet(o._wavelet)
{
  TRACE;
  _outputDirectory=o._outputDirectory;
}

AbstractParameters * HVTFAParameters::clone() const
{
  TRACE;
  return new HVTFAParameters(*this);
}

void HVTFAParameters::setVersion(PARAMETERS_SETVERSION_ARGS)
{
  TRACE;
  _timeRange.setVersion(version);
  _frequencySampling.setVersion(version);
  _wavelet.setVersion(version);
  AbstractParameters::setVersion(version);
}

int HVTFAParameters::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
{
  return 1+AbstractParameters::keywordCount();
}

void HVTFAParameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
{
  TRACE;
  int baseIndex=AbstractParameters::keywordCount();
  keywords.add(prefix+"OUTPUT DIRECTORY"+suffix, this, baseIndex);
  _timeRange.collectKeywords(keywords, prefix, suffix);
  _frequencySampling.collectKeywords(keywords, prefix, suffix);
  _wavelet.collectKeywords(keywords, prefix, suffix);
}

QString HVTFAParameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
{
  TRACE;
  QString log;
  log+=_timeRange.toString(prefix, suffix);
  log+=_frequencySampling.toString(prefix, suffix);
  log+=_wavelet.toString(prefix, suffix);
  log+=prefix+"OUTPUT DIRECTORY"+suffix+"="+_outputDirectory.absolutePath()+"\n";
  return log;
}

bool HVTFAParameters::setValue(PARAMETERS_SETVALUE_ARGS)
{
  TRACE;
  switch(index-AbstractParameters::keywordCount()) {
  case 0:
    _outputDirectory.setPath(value);
  default:
    break;
  }
  return AbstractParameters::setValue(index, value, unit, keywords);
}
