/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-19
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLES_H
#define SAMPLES_H

#include <QGpCoreStat.h>
#include <QGpCoreWave.h>

#include "Sample.h"

class Samples : public VectorList<Sample>
{
public:
  Samples() {}
  Samples(const Samples& o);

  Samples * filterUndefinedEllipticities() const;
  Samples * filterMinimumEllipticities(double threshold) const;
  Samples * filterMaximumEllipticities(double threshold) const;
  Samples * filterRelativePower(double threshold) const;
  Samples * filterCurve(const ModalCurve& curve, double relativeRange) const;
  Samples * filterNoiseSmart(double noiseDev, double slowDev) const;
  Samples * filterPowerSmart(double powerDev, double slowDev) const;
  Samples * filterMinimumVelocity(double threshold) const;
  Samples * filterMaximumVelocity(double threshold) const;
  Samples * filterMinimumWavenumber(double threshold) const;
  Samples * filterMaximumWavenumber(double threshold) const;
  Samples * filterMinimumVerticalNoise(double threshold) const;
  Samples * filterMaximumVerticalNoise(double threshold) const;
  Samples * filterMinimumHorizontalNoise(double threshold) const;
  Samples * filterMaximumHorizontalNoise(double threshold) const;
  Samples * filterMinimumTotalNoise(double threshold) const;
  Samples * filterMaximumTotalNoise(double threshold) const;
  Samples * filterMinimumDeltaNoise(double threshold) const;
  Samples * filterMaximumDeltaNoise(double threshold) const;
  Samples * filterMinimumSigmaNoise(double threshold) const;
  Samples * filterMaximumSigmaNoise(double threshold) const;
  Samples * filterAbnormalSigmaNoise() const;
  Samples * filterMinimumAzimuth(double threshold) const;
  Samples * filterMaximumAzimuth(double threshold) const;
  Samples * filterMinimumPower(double threshold) const;
  Samples * filterMaximumPower(double threshold) const;

  VectorList<Histogram2D::Sample> dispersionSamples() const;
  VectorList<Histogram2D::Sample> ellipticitySamples() const;
  VectorList<Histogram2D::Sample> verticalNoiseSamples() const;
  VectorList<Histogram2D::Sample> horizontalNoiseSamples() const;
  VectorList<Histogram2D::Sample> totalNoiseSamples() const;
  VectorList<Histogram2D::Sample> deltaNoiseSamples() const;
  VectorList<Histogram2D::Sample> sigmaNoiseSamples() const;
  VectorList<Histogram2D::Sample> azimuthSamples() const;
  VectorList<Histogram2D::Sample> powerSamples() const;

  void setHeaderLine(const QString& l) {_headerLine=l;}
  const QString& headerLine() const {return _headerLine;}

  void setValid(const Histogram2D& o);

  bool save(const QString& fileName) const;
private:
  static bool lessThan(const Sample& s1, const Sample& s2);
  static bool lessThanSlowness(const Sample& s1, const Sample& s2);
  void selectPower(Samples& samples, int beginIndex, int endIndex, double minPower) const;

  QString _headerLine;
};

#endif // SAMPLES_H

