/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-01-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ClassificationParameters.h"

/*!
  \class ClassificationParameters ClassificationParameters.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ClassificationParameters::ClassificationParameters()
  : SampleClassificationParameters()
{
  _data=Reader::Dispersion;
}

/*!
  Description of destructor still missing
*/
ClassificationParameters::ClassificationParameters(const ClassificationParameters& o)
  : SampleClassificationParameters(o)
{
  _data=o._data;
}


AbstractParameters * ClassificationParameters::clone() const
{
  return new ClassificationParameters(*this);
}

int ClassificationParameters::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
{
  return 1+SampleClassificationParameters::keywordCount();
}

void ClassificationParameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
{
  TRACE;
  int baseIndex=SampleClassificationParameters::keywordCount();
  SampleClassificationParameters::collectKeywords(keywords, prefix, suffix);
  keywords.add(prefix+"DATA", this, baseIndex);
}

QString ClassificationParameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
{
  TRACE;
  QString log;
  log+="# Data can be: Dispersion, Ellipticity, Noise, Azimuth or Power\n";
  log+=prefix+"DATA"+suffix+"="+data(_data)+"\n";
  log+=SampleClassificationParameters::toString(prefix, suffix);
  return log;
}

bool ClassificationParameters::setValue(PARAMETERS_SETVALUE_ARGS)
{
  TRACE;
  bool ok=true;
  switch(index-SampleClassificationParameters::keywordCount()) {
  case 0:
    _data=data(value, ok);
    return ok;
  default:
    break;
  }
  return SampleClassificationParameters::setValue(index, value, unit, keywords);
}

Reader::Plot ClassificationParameters::data(QString d, bool& ok)
{
  d=d.toLower();
  if(d.size()>=1) {
    switch(d[0].unicode()) {
    case 'd':
      if(d=="dispersion") {
        return Reader::Dispersion;
      } else if(d=="deltaNoise") {
        return Reader::DeltaNoise;
      }
      break;
    case 'e':
      if(d=="ellipticity") {
        return Reader::Ellipticity;
      }
      break;
    case 'v':
      if(d=="verticalNoise") {
        return Reader::VerticalNoise;
      }
      break;
    case 'h':
      if(d=="horizontalNoise") {
        return Reader::HorizontalNoise;
      }
      break;
    case 't':
      if(d=="totalNoise") {
        return Reader::TotalNoise;
      }
      break;
    case 's':
      if(d=="sigmaNoise") {
        return Reader::SigmaNoise;
      }
      break;
    case 'a':
      if(d=="azimuth") {
        return Reader::Azimuth;
      }
      break;
    case 'p':
      if(d=="power") {
        return Reader::Power;
      }
      break;
    default:
      break;
    }
  }
  ok=false;
  return Reader::Dispersion;
}

QString ClassificationParameters::data(Reader::Plot d)
{
  switch(d) {
  case Reader::Dispersion:
    return "Dispersion";
  case Reader::Ellipticity:
    return "Ellipticity";
  case Reader::VerticalNoise:
    return "VerticalNoise";
  case Reader::HorizontalNoise:
    return "HorizontalNoise";
  case Reader::TotalNoise:
    return "TotalNoise";
  case Reader::DeltaNoise:
    return "DeltaNoise";
  case Reader::SigmaNoise:
    return "SigmaNoise";
  case Reader::Azimuth:
    return "Azimuth";
  case Reader::Power:
    break;
  }
  return "Power";
}
