/***************************************************************************
**
**  This file is part of gptime.
**
**  gptime is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gptime is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-19
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEREADER_H
#define TIMEREADER_H

#include <QGpCoreTools.h>

class TimeReader : public ArgumentStdinReader
{
  TRANSLATIONS("TimeReader")
public:
  TimeReader();

  bool setOptions(int& argc, char ** argv);
protected:
  virtual bool parse(QTextStream& s);
private:
  DateTime inDateTime(const QString& s, bool& ok);
  QString outDateTime(const DateTime& dt);

  enum Action {None, Convert};
  enum Mode {Absolute, Relative};
  Mode _mode;
  Action _action;
  int _startByte, _endByte, _column;
  QString _delimiters;
  QStringList _inFormats;
  QString _outFormat;
  int _outputPrecision;
  bool _verbose;
};

#endif // TIMEREADER_H
