/***************************************************************************
**
**  This file is part of gptarget.
**
**  gptarget is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gptarget is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-28
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TARGETADD_H
#define TARGETADD_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "AbstractTarget.h"

class TargetAdd : public AbstractTarget
{
  TRANSLATIONS("TargetAdd")
public:
  TargetAdd();
  ~TargetAdd();

  virtual bool setOptions(int& argc, char ** argv);
  virtual int execute();
private:
  void readCurves(QList<ModalCurve>& curves, QTextStream& s);
  void readCurves(QList<MagnetoTelluricCurve>& curves, QTextStream& s);

  enum Type {Undefined,
             Dispersion, Autocorr, EllipticityCurve, EllipticityPeak,
             RefractionVp, RefractionVs, MagnetoTelluric};
  Type _type;
  Mode _mode;
  Point * _position;
  double _weight, _minimumMisfit;
};

#endif // TARGETADD_H
